// Skin specific Javascript
if ("scImageMgr" in window) scImageMgr.fOverAlpha=.9;

// DARK LIGHT MODE SET AND SWITCH
(function (){
  const vLangStr = {
    en : {thm : "theme", changeToDark : "Change to dark theme", changeToLight : "Change to light theme"},
    fr : {thm : "thème", changeToDark : "Passer au thème sombre", changeToLight : "Passer au thème clair"},
    ar : {thm : "خلفية مبيانية", changeToDark : "التبديل إلى المظهر الداكن", changeToLight : "التبديل إلى موضوع الضوء"},
    es : {thm : "tema", changeToDark : "Cambiar a tema oscuro", changeToLight : "Cambiar a tema claro"},
    it : {thm : "tema", changeToDark : "Cambiare al tema scuro", changeToLight : "Cambiare al tema chiaro"},
    pt : {thm : "tema", changeToDark : "Mudar para o tema escuro", changeToLight : "Mudar para o tema claro"}
  }
  const vLang = document.documentElement.getAttribute("lang");
  const vStrList = vLangStr[vLang] ? vLangStr[vLang] : vLangStr["en"];
  let vBd = dom.newBd(sc$("root"));
  vBd.elt("a", "themeBtn")
    .att("href", "#")
    .att("role", "button")
    .prop("fStrList", vStrList)
    .prop("fTheme", localStorage.getItem("theme-preference") ? localStorage.getItem("theme-preference") : window.matchMedia("(prefers-color-scheme: dark)").matches ? "dark" : "light")
    .prop("setPreference", function (){
      localStorage.setItem("theme-preference", this.fTheme);
      this.reflectPreference();
    })
    .prop("reflectPreference", function (){
      document.documentElement.setAttribute("data-theme", this.fTheme);
      this.setAttribute("title", this.fTheme === "dark" ? this.fStrList["changeToLight"] : this.fStrList["changeToDark"]);
    })
    .listen("click", function(){
      this.fTheme = this.fTheme === "light" ? "dark" : "light";
      this.setPreference();
    })
    .call("reflectPreference")
    .elt("span").text(vStrList["thm"]).up().up();

  window.matchMedia("(prefers-color-scheme: dark)").addEventListener("change", ({matches:isDark}) => {
    const vBtn = scPaLib.findNode("ide:root/des:.themeBtn");
    vBtn.fTheme = isDark ? "dark" : "light";
    vBtn.setPreference();
  });
})();

// MENU MOBILE
(function (){
  if (!sc$("header")) return;
  const vLangStr = {
    en : {mnu : "Menu", openMnu : "Open the menu", closeMnu : "Close the menu"},
    fr : {mnu : "Menu", openMnu : "Ouvrir le menu", closeMnu : "Fermer le menu"},
    ar : {mnu : "القائمة", openMnu : "فتح القائمة", closeMnu : "إغلاق القائمة"},
    es : {mnu : "Menú", openMnu : "Abrir el menú", closeMnu : "Cerrar el menú"},
    it : {mnu : "Menu", openMnu : "Apri menu", closeMnu : "Chuidi menu"},
    pt : {mnu : "Menu", openMnu : "Abrir o menu", closeMnu : "Fechar o menu"}
  }
  const vLang = document.documentElement.getAttribute("lang");
  const vStrList = vLangStr[vLang] ? vLangStr[vLang] : vLangStr["en"];
  let vBd = dom.newBd(sc$("header"));
  vBd.elt("a", "menuBtn")
    .att("href", "#")
    .att("role", "button")
    .att("title", vStrList["openMnu"])
    .prop("fStrList", vStrList)
    .listen("click", function(){
      this.fOpen = this.fOpen !== true;
      this.setAttribute("title", this.fOpen ? this.fStrList["closeMnu"] : this.fStrList["openMnu"]);
      if (this.fOpen) document.body.classList.add("menuOpen");
      else document.body.classList.remove("menuOpen");
    })
    .elt("span").text(vStrList["mnu"]).up().up();
  try{
    searchMgr.register("find", function (){
      const vMnuBtn = scPaLib.findNode("ide:header/chi:.menuBtn");
      if (vMnuBtn.fOpen) vMnuBtn.click();
    });
  } catch (e) {}
})();
